unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,
  UWatek, StdCtrls, Buttons, ExtCtrls;

type
  TMainForm = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    btnSTART: TBitBtn;
    btnSTOP: TBitBtn;
    btnWZNOW: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure btnSTARTClick(Sender: TObject);
    procedure btnSTOPClick(Sender: TObject);
    procedure btnWZNOWClick(Sender: TObject);
  private

	ilosc_watkow : Integer;
   my_thread    : MWatek;

  public
	 procedure ThreadDone(Sender :TObject);
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.btnSTARTClick(Sender: TObject);
begin
   if btnSTART.Caption = '&Start' then
   begin
      btnSTART.Caption := '&Koniec';
      Memo1.Clear();

      my_thread := MWatek.Create(false, Memo1);
      my_thread.OnTerminate := ThreadDone;

      ilosc_watkow  := 1;
   end
   else begin
      Application.Terminate();
   end;
end;

procedure TMainForm.btnSTOPClick(Sender: TObject);
begin
   if ilosc_watkow > 0 then
   begin
      if not my_thread.Suspended then
      begin
         // zabija wtek my_thread.Terminate();
         my_thread.Suspend();
         Dec(ilosc_watkow);
      end;
   end;
end;

procedure TMainForm.btnWZNOWClick(Sender: TObject);
begin
   if ilosc_watkow = 0 then
   begin
      if Assigned(my_thread) then
      begin
         my_thread.Resume();
         Inc(ilosc_watkow);
      end
      else begin
         ShowMessage('Pami dla wtku zostaa ju usunita');
      end;
   end;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
   Memo1.Clear();
   Memo1.Align := alLeft;
end;

procedure TMainForm.ThreadDone(Sender : TObject);
begin
	(*
   ten fragment si wykona gdy wtek zakoczy sie
   w sposb 'naturany', lub zostanie wywoana jawnie instrukjca
   MWatek.Terminate()
   *)
   Dec(ilosc_watkow);
   Memo1.Lines.Add('Thread terminated Ilo dziaajcych wtkw: ' + IntToStr(ilosc_watkow));
end;

end.

